jQuery(document).ready(function($){
    var logoHeight = $('body').data('logo-height');
    var headerPadding = 0;
    var usingLogoImage = 1;
    var dataHeaderResize = 1;
    var smallNavLineHeight = $('body').attr('data-height')+'px';
    var smallNavHeight = $('body').data('height');
    var bigNavHeight = 80;
    if( isNaN(headerPadding) || headerPadding.length == 0 ) {
        headerPadding = 20;
    }
    function headerInit() {
        var $headerWraper = $('section[id^=sp-header-wrapper],header[id^=sp-header-wrapper]');
        $headerWraper.find('#sp-logo img').height(logoHeight);
        $('section[id^=sp-header-wrapper],header[id^=sp-header-wrapper]').css({
            'padding-top' : headerPadding
        });

        $('#sp-main-menu > ul > li > a').css({
            'padding-bottom' : ((logoHeight/2) - ($('#sp-main-menu > ul > li > a').height()/2)) + headerPadding,
            'padding-top' : (logoHeight/2) - ($('#sp-main-menu > ul > li > a').height()/2),
        });

        $('header#top .sf-menu > li > ul, header#top .sf-menu > li.sfHover > ul').css({
            'top' : $('#sp-main-menu > ul > li > a').outerHeight()
        });

        $('section[id^=sp-header-wrapper],header[id^=sp-header-wrapper] .container').css('visibility','visible');
        if(usingLogoImage == false) $('header#top #sp-logo').css('margin-top','4px');

    }
    var headerResize = dataHeaderResize;
    if( headerResize == 1 ){
        headerInit();
        $(window).bind('scroll',smallNav);
        if($('body').hasClass('mobile')){
            $(window).resize(headerInit);
        }
    }
    else {
        headerInit();
    }

    function smallNav(){
        var $offset = $(window).scrollTop();
        var $windowWidth = $(window).width();
        var shrinkNum = 6;
        var $offsetTop = 0;
        $('section[id^=sp-header-wrapper],header[id^=sp-header-wrapper]').prevAll('section').each(function(i){
            $offsetTop += $(this).height();
        });
        var $headerWraper = $('section[id^=sp-header-wrapper],header[id^=sp-header-wrapper]');
        if (logoHeight >= 40 && logoHeight < 60) shrinkNum = 8;
        else if (logoHeight >= 60 && logoHeight < 80) shrinkNum = 10;
        else if (logoHeight >= 80 ) shrinkNum = 14;

        if($offset > $offsetTop && $windowWidth > 1000) {
            $headerWraper.css({position:'fixed',top:0, 'background':'#fff','width':'100%','z-index':'1010','border-bottom':'1px solid #EBEBEB','box-shadow':'0 0 3px #DFDFDF','-webkit-box-shadow':'0 0 3px #DFDFDF'});
            $headerWraper.find('ul.level-0 >li > a,a.logo,#searchsubmit').css({lineHeight:'60px','transition':'all 500ms ease-in-out 0s','-webkit-transition':'all 500ms ease-in-out 0s','-moz-transition':'all 500ms ease-in-out 0s'});
            $headerWraper.find('#sp-logo img').stop(true,true).animate({
                'height' : logoHeight/bigNavHeight*smallNavHeight
            },{
                queue:false,
                duration:250,
                easing: 'easeOutCubic'
            });
            $headerWraper.stop(true,true).animate({
                'padding-top' : headerPadding / 1.8
            },{
                queue:false,
                duration:250,
                easing: 'easeOutCubic'
            });
            $headerWraper.find('#sp-logo img').css({'height':'18px','transition':'all 500ms ease-in-out 0s','-webkit-transition':'all 500ms ease-in-out 0s'});
            $headerWraper.find('#mod-search-searchword').css({'margin':'14px 0','transition':'all 500ms ease-in-out 0s','-webkit-transition':'all 500ms ease-in-out 0s'});
            if($('body').attr('data-header-resize') == 1){
                $headerWraper.addClass('fixed-top');
                $headerWraper.find('ul.level-0 >li > a,a.logo,span[class^=jmsocials]').css({lineHeight:smallNavLineHeight});
            }
            $('#mod-search-searchword').animate({marginTop:(smallNavHeight-24)/2},250);
            $('#sp-main-menu > ul > li > a').stop(true,true).animate({
                'padding-bottom' : (((logoHeight-shrinkNum)/2) - ($('#sp-main-menu > ul > li > a').height()/2)) + headerPadding / 1.8,
                'padding-top' : ((logoHeight-shrinkNum)/2) - ($('#sp-main-menu > ul > li > a').height()/2)
            },{
                queue:false,
                duration:250,
                easing: 'easeOutCubic'
            });

            $('header#top .sf-menu > li > ul, header#top .sf-menu > li.sfHover > ul').stop(true,true).animate({
                'top' : Math.floor($('#sp-main-menu > ul > li > a').height() + (((logoHeight-shrinkNum)/2) - ($('#sp-main-menu > ul > li > a').height()/2))*2 + headerPadding / 1.8)
            },{
                queue:false,
                duration:250,
                easing: 'easeOutCubic'
            });
            if(usingLogoImage == false) $('header#top #sp-logo').stop(true,true).animate({
                'margin-top' : 0
            },{
                queue:false,
                duration:450,
                easing: 'easeOutExpo'
            });

            $(window).unbind('scroll',smallNav);
            $(window).bind('scroll',bigNav);
        }
    }

    function bigNav(){
        var $offset = $(window).scrollTop();
        var $windowWidth = $(window).width();
        var $offsetTop = 0;
        $('section[id^=sp-header-wrapper],header[id^=sp-header-wrapper]').prevAll('section').each(function(i){
            $offsetTop += $(this).height();
        });
        var $headerWraper = $('section[id^=sp-header-wrapper],header[id^=sp-header-wrapper]');
        if($offset <= $offsetTop && $windowWidth > 1000) {
            $headerWraper.removeClass('fixed-top');
            $headerWraper.find('#sp-logo img').stop(true,true).animate({
                'height' : logoHeight
            },{
                queue:false,
                duration:250,
                easing: 'easeOutCubic'
            });
            $('body').css({paddingTop:0});
            $headerWraper.css({
                'position':'relative','border-bottom':'none'
            });
            $headerWraper.stop(true,true).animate({
                'padding-top' : headerPadding
            },{
                queue:false,
                duration:250,
                easing: 'easeOutCubic'
            });
            $headerWraper.find('ul.level-0 >li > a,a.logo,#searchsubmit').css({lineHeight:'80px'});
            $headerWraper.find('#sp-logo img').css({'height':'25px'});
            $headerWraper.find('#mod-search-searchword').css({'margin':'23px 0'});
            $('#sp-main-menu > ul > li > a').stop(true,true).animate({
                'padding-bottom' : ((logoHeight/2) - ($('#sp-main-menu > ul > li > a').height()/2)) + headerPadding,
                'padding-top' : (logoHeight/2) - ($('#sp-main-menu > ul > li > a').height()/2),
            },{
                queue:false,
                duration:250,
                easing: 'easeOutCubic'
            });

            $('header#top .sf-menu > li > ul, header#top .sf-menu > li.sfHover > ul').stop(true,true).animate({
                'top' : $('#sp-main-menu > ul > li > a').height() + (((logoHeight)/2) - ($('#sp-main-menu > ul > li > a').height()/2))*2 + headerPadding
            },{
                queue:false,
                duration:250,
                easing: 'easeOutCubic'
            });
            if(usingLogoImage == false) $('header#top #sp-logo').stop(true,true).animate({
                'margin-top' : 4
            },{
                queue:false,
                duration:450,
                easing: 'easeOutExpo'
            });

            $(window).unbind('scroll',bigNav);
            $(window).bind('scroll',smallNav);
        }
    }
    if( $('#sc-accordion .toggle').hasClass('open') ){
        $('#sc-accordion .toggle').find('i').attr('class','icon-minus-sign');
    } else {
        $('#sc-accordion .toggle').find('i').attr('class','icon-plus-sign');
    }
    $('.toggle h3 a').click(function(){
        if(!$(this).parents('.toggles').hasClass('accordion')) {
            var $toggle = $(this).parents('.toggle');
            $(this).parents('.toggle').parent().find('.toggle').not($toggle).removeClass('open').find('> div').slideUp(300);
            $(this).parents('.toggle').parent().find('.toggle').not($toggle).find('i').removeClass('icon-minus-sign').addClass('icon-plus-sign');
            $(this).parents('.toggle').find('> div').slideToggle(300);
            $(this).parents('.toggle').toggleClass('open');
            if( $(this).parents('.toggle').hasClass('open') ){
                $(this).find('i').attr('class','icon-minus-sign');
            } else {
                $(this).find('i').attr('class','icon-plus-sign');
            }
        }
        return false;
    });
    $('.toggle').first().addClass('open').find('> div').show();
    $('.toggle').first().find('i').attr('class','icon-minus-sign');
    $('.carousel').each(function(index, element) {
        if(typeof $(this)[index] != 'undefined'){
            $(this)[index].slide = null;
            $($(this)[index]).find('.item img').css({maxWidth:$($(this)[index]).width()});
            $($(this)[index]).find('p').css({margin:0});
        }
    });
});