<?php
/**
 * @version		$Id: comments.php 1812 2013-01-14 18:45:06Z lefteris.kavadas $
 * @package		K2
 * @author		JoomlaWorks http://www.joomlaworks.net
 * @copyright	Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.
 * @license		GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */

// no direct access
defined('_JEXEC') or die;

?>

<div id="k2ModuleBox<?php echo $module->id; ?>" class="k2LatestCommentsBlock<?php if($params->get('moduleclass_sfx')) echo ' '.$params->get('moduleclass_sfx'); ?>">

	<?php if(count($comments)): ?>
	<ul>
		<?php foreach ($comments as $key=>$comment):	?>
		<li class="<?php echo ($key%2) ? "odd" : "even"; if(count($comments)==$key+1) echo ' lastItem'; ?>">
			<div class="user-avatar k2-td">
			<?php if($comment->userImage): ?>
			<a class="k2Avatar lcAvatar" href="<?php echo $comment->link; ?>" title="<?php echo K2HelperUtilities::cleanHtml($comment->commentText); ?>">
				<img src="<?php echo $comment->userImage; ?>" alt="<?php echo JFilterOutput::cleanText($comment->userName); ?>" style="width:<?php echo $lcAvatarWidth; ?>px;height:auto;" />
			</a>
			<?php endif; ?>
			</div>

			<div class="comment-content k2-td">
				<?php if($params->get('commenterName')): ?>
				<span class="lcUsername">
					<?php if(isset($comment->userLink)): ?>
					<a rel="author" href="<?php echo $comment->userLink; ?>"><?php echo $comment->userName; ?></a>
					<?php elseif($comment->commentURL): ?>
					<a target="_blank" rel="nofollow" href="<?php echo $comment->commentURL; ?>"><?php echo $comment->userName; ?></a>
					<?php else: ?>
					<?php echo $comment->userName; ?>
					<?php endif; ?>
				</span>
				<?php endif; ?>
				<span class="lcComment"><?php echo $comment->commentText; ?></span>

				<?php if($params->get('commentDate')): ?>
				<span class="lcCommentDate">
					<?php if($params->get('commentDateFormat') == 'relative'): ?>
					<?php echo $comment->commentDate; ?>
					<?php else: ?>
					<?php echo JHTML::_('date', $comment->commentDate, JText::_('K2_DATE_FORMAT_LC2')); ?>
					<?php endif; ?>
				</span>
				<?php endif; ?>
			</div>	
		</li>
		<?php endforeach; ?>
	</ul>
	<?php endif; ?>
</div>
