<?php
/**
 * @version     $Id: category_item.php 1812 2013-01-14 18:45:06Z lefteris.kavadas $
 * @package     K2
 * @author      JoomlaWorks http://www.joomlaworks.net
 * @copyright   Copyright (c) 2006 - 2013 JoomlaWorks Ltd. All rights reserved.
 * @license     GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */

// no direct access
defined('_JEXEC') or die;

// Define default image size (do not change)
K2HelperUtilities::setDefaultImage($this->item, 'itemlist', $this->params);

?>

<!-- Start K2 Item Layout -->
<div class="catItemView group<?php echo ucfirst($this->item->itemGroup); ?><?php echo ($this->item->featured) ? ' catItemIsFeatured' : ''; ?><?php if($this->item->params->get('pageclass_sfx')) echo ' '.$this->item->params->get('pageclass_sfx'); ?>">

    <!-- Plugins: BeforeDisplay -->
    <?php echo $this->item->event->BeforeDisplay; ?>

    <!-- K2 Plugins: K2BeforeDisplay -->
    <?php echo $this->item->event->K2BeforeDisplay; ?>
    <div class="itemLinkGroupLeft span5">
      <div class="catItemImageBlock">
          <div class="catItemImage">
             <img src="<?php echo $this->item->image; ?>" alt="<?php if(!empty($this->item->image_caption)) echo K2HelperUtilities::cleanHtml($this->item->image_caption); else echo K2HelperUtilities::cleanHtml($this->item->title); ?>" style="width:<?php echo $this->item->imageWidth; ?>px; height:auto;" />
            <div class="image-overlay overlay-type-extern">
              <a class="image-overlay-inside" href="<?php echo $this->item->link; ?>" title="<?php if(!empty($this->item->image_caption)) echo K2HelperUtilities::cleanHtml($this->item->image_caption); else echo K2HelperUtilities::cleanHtml($this->item->title); ?>">
                 
              </a>
            </div>  
          </div>
          <div class="clr"></div>
      </div>
    </div>

    <div class="itemLinkGroupRight span7">
        <div class="catItemHeader">
         <?php if($this->item->params->get('catItemTitle')): ?>
        <!-- Item title -->
        <h3 class="catItemTitle">
              <?php if(isset($this->item->editLink)): ?>
              <!-- Item edit link -->
              <span class="catItemEditLink">
                  <a class="modal" rel="{handler:'iframe',size:{x:990,y:550}}" href="<?php echo $this->item->editLink; ?>">
                      <?php echo JText::_('K2_EDIT_ITEM'); ?>
                  </a>
              </span>
              <?php endif; ?>

          <?php if ($this->item->params->get('catItemTitleLinked')): ?>
              <a href="<?php echo $this->item->link; ?>">
              <?php echo $this->item->title; ?>
          </a>
          <?php else: ?>
          <?php echo $this->item->title; ?>
          <?php endif; ?>

          <?php if($this->item->params->get('catItemFeaturedNotice') && $this->item->featured): ?>

          <!-- Featured flag -->
          <span>
              <sup>
                  <?php echo JText::_('K2_FEATURED'); ?>
              </sup>
          </span>
          <?php endif; ?>
        </h3>
        <div class="catItemMeta">
            <?php if($this->item->params->get('catItemDateCreated')): ?>
            <!-- Date created -->
            <span class="catItemDateCreated">
                <i class="fa-clock-o fa"></i><?php echo JHTML::_('date', $this->item->created , JText::_('K2_DATE_FORMAT_LC2')); ?>
            </span>
            <?php endif; ?>
        <?php endif; ?>

         <?php if($this->item->params->get('catItemCommentsAnchor') && ( ($this->item->params->get('comments') == '2' && !$this->user->guest) || ($this->item->params->get('comments') == '1')) ): ?>
          <!-- Anchor link to comments below -->
        <span class="catItemCommentsLink">
              <?php if(!empty($this->item->event->K2CommentsCounter)): ?>
                  <!-- K2 Plugins: K2CommentsCounter -->
                  <?php echo $this->item->event->K2CommentsCounter; ?>
              <?php else: ?>
                  <?php if($this->item->numOfComments > 0): ?>
                  <i class="fa-comments fa"></i><a href="<?php echo $this->item->link; ?>#itemCommentsAnchor">
                      <?php echo $this->item->numOfComments; ?> <?php echo ($this->item->numOfComments>1) ? JText::_('K2_COMMENTS') : JText::_('K2_COMMENT'); ?>
                  </a>
                  <?php else: ?>
                  <a href="<?php echo $this->item->link; ?>#itemCommentsAnchor">
                      <?php echo JText::_('K2_BE_THE_FIRST_TO_COMMENT'); ?>
                  </a>
                  <?php endif; ?>
              <?php endif; ?>
        </span>
        <?php endif; ?>
        
        <?php if($this->item->params->get('catItemAuthor')): ?>
        <!-- Item Author -->
        <span class="catItemAuthor">
            <?php //echo K2HelperUtilities::writtenBy($this->item->author->profile->gender); ?> 
            <?php if(isset($this->item->author->link) && $this->item->author->link): ?>
            <i class="fa-user fa"></i><a rel="author" href="<?php echo $this->item->author->link; ?>"><?php echo $this->item->author->name; ?></a>
            <?php else: ?>
            <?php echo $this->item->author->name; ?>
            <?php endif; ?>
        </span>
        <?php endif; ?>
       
        <?php if($this->item->params->get('catItemCategory')): ?>
        <!-- Item category name -->
        <span class="catItemCategory">
            <i class="fa-bookmark fa"></i><a href="<?php echo $this->item->category->link; ?>"><?php echo $this->item->category->name; ?></a>
        </span>
        <?php endif; ?>
        </div><!-- End Item Meta -->
  </div><!-- catItemHeader -->

  <!-- Plugins: AfterDisplayTitle -->
  <?php echo $this->item->event->AfterDisplayTitle; ?>

  <!-- K2 Plugins: K2AfterDisplayTitle -->
  <?php echo $this->item->event->K2AfterDisplayTitle; ?>

    <?php if($this->item->params->get('catItemRating')): ?>
    <!-- Item Rating -->
    <div class="catItemRatingBlock">
        <span><?php echo JText::_('K2_RATE_THIS_ITEM'); ?></span>
        <div class="itemRatingForm">
            <ul class="itemRatingList">
                <li class="itemCurrentRating" id="itemCurrentRating<?php echo $this->item->id; ?>" style="width:<?php echo $this->item->votingPercentage; ?>%;"></li>
                <li><a href="#" rel="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_1_STAR_OUT_OF_5'); ?>" class="one-star">1</a></li>
                <li><a href="#" rel="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_2_STARS_OUT_OF_5'); ?>" class="two-stars">2</a></li>
                <li><a href="#" rel="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_3_STARS_OUT_OF_5'); ?>" class="three-stars">3</a></li>
                <li><a href="#" rel="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_4_STARS_OUT_OF_5'); ?>" class="four-stars">4</a></li>
                <li><a href="#" rel="<?php echo $this->item->id; ?>" title="<?php echo JText::_('K2_5_STARS_OUT_OF_5'); ?>" class="five-stars">5</a></li>
            </ul>
            <div id="itemRatingLog<?php echo $this->item->id; ?>" class="itemRatingLog"><?php echo $this->item->numOfvotes; ?></div>
            <div class="clr"></div>
        </div>
        <div class="clr"></div>
    </div>
    <?php endif; ?>

  <div class="catItemBody">

      <!-- Plugins: BeforeDisplayContent -->
      <?php echo $this->item->event->BeforeDisplayContent; ?>

      <!-- K2 Plugins: K2BeforeDisplayContent -->
      <?php echo $this->item->event->K2BeforeDisplayContent; ?>

      <?php if($this->item->params->get('catItemImage') && !empty($this->item->image)): ?>
      <!-- Item Image -->
      
      <?php endif; ?>

      <?php if($this->item->params->get('catItemIntroText')): ?>
      <!-- Item introtext -->
      <div class="catItemIntroText">
        <?php echo $this->item->introtext; ?>
      </div>
      <?php endif; ?>

        <div class="clr"></div>

      <?php if($this->item->params->get('catItemExtraFields') && count($this->item->extra_fields)): ?>
      <!-- Item extra fields -->
      <div class="catItemExtraFields">
        <h4><?php echo JText::_('K2_ADDITIONAL_INFO'); ?></h4>
        <ul>
            <?php foreach ($this->item->extra_fields as $key=>$extraField): ?>
            <?php if($extraField->value != ''): ?>
            <li class="<?php echo ($key%2) ? "odd" : "even"; ?> type<?php echo ucfirst($extraField->type); ?> group<?php echo $extraField->group; ?>">
                <?php if($extraField->type == 'header'): ?>
                <h4 class="catItemExtraFieldsHeader"><?php echo $extraField->name; ?></h4>
                <?php else: ?>
                <span class="catItemExtraFieldsLabel"><?php echo $extraField->name; ?></span>
                <span class="catItemExtraFieldsValue"><?php echo $extraField->value; ?></span>
                <?php endif; ?>
            </li>
            <?php endif; ?>
            <?php endforeach; ?>
            </ul>
        <div class="clr"></div>
      </div>
      <?php endif; ?>

      <!-- Plugins: AfterDisplayContent -->
      <?php echo $this->item->event->AfterDisplayContent; ?>

      <!-- K2 Plugins: K2AfterDisplayContent -->
      <?php echo $this->item->event->K2AfterDisplayContent; ?>

      <div class="clr"></div>
  </div>

  <div class="catItemFooter">
  <?php if(
  $this->item->params->get('catItemHits') ||
  $this->item->params->get('catItemCategory') ||
  $this->item->params->get('catItemTags') ||
  $this->item->params->get('catItemAttachments')
  ): ?>
  <div class="catItemLinks">

        <?php if($this->item->params->get('catItemHits')): ?>
        <!-- Item Hits -->
        <div class="catItemHitsBlock">
            <span class="catItemHits">
                <?php echo JText::_('K2_READ'); ?> <b><?php echo $this->item->hits; ?></b> <?php echo JText::_('K2_TIMES'); ?>
            </span>
        </div>
        <?php endif; ?>

      <?php if($this->item->params->get('catItemTags') && count($this->item->tags)): ?>
      <!-- Item tags -->
      <div class="catItemTagsBlock">
          <ul class="catItemTags">
            <li class="frist"><i class="fa-tags fa"></i></li>
            <?php foreach ($this->item->tags as $tag): ?>
            <li><a href="<?php echo $tag->link; ?>"><?php echo $tag->name; ?></a></li>
            <?php endforeach; ?>
          </ul>
      </div>
      <?php endif; ?>

  </div>
  <?php endif; ?>
    <?php if ($this->item->params->get('catItemReadMore')): ?>
    <!-- Item "read more..." link -->
    <div class="catItemReadMore">
        <a class="k2ReadMore" href="<?php echo $this->item->link; ?>">
            <i class="fa-share fa"></i><?php echo JText::_('K2_READ_MORE'); ?>
        </a>
    </div>
    <?php endif; ?>
  <!-- Plugins: AfterDisplay -->
  <?php echo $this->item->event->AfterDisplay; ?>

  
  <!-- K2 Plugins: K2AfterDisplay -->
  <?php echo $this->item->event->K2AfterDisplay; ?>
  </div>
    </div>  
</div>
<!-- End K2 Item Layout -->

