<?php
/* * --------------------------------------------------------------------
  # Package - JoomlaMan Module
  # Version 1.0
  # --------------------------------------------------------------------
  # Author - JoomlaMan http://www.joomlaman.com
  # Copyright (c) 2012 - 2013 JoomlaMan.com. All Rights Reserved.
  # @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
  # Websites: http://www.JoomlaMan.com
  ---------------------------------------------------------------------* */
defined('_JEXEC') || die('Restricted access');
class Date_Difference
{
    public static function getStringResolved($date, $compareTo = NULL)
    {
        if(!is_null($compareTo)) {
            $compareTo = new DateTime($compareTo);
        }
        return self::getString(new DateTime($date), $compareTo);
    }

    public static function getString(DateTime $date, DateTime $compareTo = NULL)
    {
        if(is_null($compareTo)) {
            $compareTo = new DateTime('now');
        }
        $diff = $compareTo->format('U') - $date->format('U');
        $dayDiff = floor($diff / 86400);

    	if(is_nan($dayDiff) || $dayDiff < 0) {
    		return '';
        }
    			
    	if($dayDiff == 0) {
            if($diff < 60) {
                return 'Just now';
            } elseif($diff < 120) {
                return '1 minute ago';
            } elseif($diff < 3600) {
                return floor($diff/60) . ' minutes ago';
            } elseif($diff < 7200) {
                return '1 hour ago';
            } elseif($diff < 86400) {
                return floor($diff/3600) . ' hours ago';
            }
        } elseif($dayDiff == 1) {
            return 'Yesterday';
        } elseif($dayDiff < 7) {
            return $dayDiff . ' days ago';
        } elseif($dayDiff == 7) {
            return '1 week ago';
        } elseif($dayDiff < (7*6)) { // Modifications Start Here
            // 6 weeks at most
            return ceil($dayDiff/7) . ' weeks ago';
        } elseif($dayDiff < 365) {
            return ceil($dayDiff/(365/12)) . ' months ago';
        } else {
            $years = round($dayDiff/365);
            return $years . ' year' . ($years != 1 ? 's' : '') . ' ago';
        }
    }
}