<?php
/**
 * @package	AcyMailing for Joomla!
 * @version	4.6.2
 * @author	acyba.com
 * @copyright	(C) 2009-2014 ACYBA S.A.R.L. All rights reserved.
 * @license	GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */
defined('_JEXEC') or die('Restricted access');
?><?php


class StatsViewStats extends acymailingView
{

	var $searchFields = array('b.subject','b.alias','a.mailid');
	var $selectFields = array('b.subject','b.alias','b.type','a.*','a.bouncedetails');
	var $searchHistory = array('b.subject','c.email','c.name');
	var $historyFields = array('a.*','b.subject','c.email','c.name');
	var $detailSearchFields = array('b.subject','b.alias','a.mailid','c.name','c.email','a.subid');
	var $detailSelectFields = array('b.subject','b.alias','c.name','c.email','b.type','a.ip','a.*');


	function display($tpl = null)
	{
		$function = $this->getLayout();
		if(method_exists($this,$function)) $this->$function();

		parent::display($tpl);
	}

	function unsubchart(){
		$mailid = JRequest::getInt('mailid');
		if(empty($mailid)) return;

		$doc = JFactory::getDocument();
		$doc->addStyleSheet( ACYMAILING_CSS.'acyprint.css?v='.filemtime(ACYMAILING_MEDIA.'css'.DS.'acyprint.css'),'text/css','print' );

		$db = JFactory::getDBO();
		$db->setQuery('SELECT * FROM #__acymailing_history WHERE mailid = '.intval($mailid).' AND action="unsubscribed" LIMIT 10000');
		$entries = $db->loadObjectList();

		if(empty($entries)){
			acymailing_display("No data recorded for that Newsletter",'warning');
			return;
		}

		$unsubreasons = array();
		$unsubreasons['NO_REASON'] = 0;
		foreach($entries as $oneEntry){
			if(empty($oneEntry->data)){
				$unsubreasons['NO_REASON']++;
				continue;
			}

			$allReasons = explode("\n",$oneEntry->data);
			$added = false;
			foreach($allReasons as $oneReason){
				list($reason,$value) = explode('::',$oneReason);
				if(empty($value) || $reason != 'REASON') continue;
				$unsubreasons[$value] = @$unsubreasons[$value] +1;
				$added = true;
			}
			if(!$added) $unsubreasons['NO_REASON']++;
		}

		$finalReasons = array();
		foreach($unsubreasons as $oneReason => $total){
			$name = $oneReason;
			if(preg_match('#^[A-Z_]*$#',$name)) $name = JText::_($name);
			$finalReasons[$name] = $total;
		}

		arsort($finalReasons);

		$doc = JFactory::getDocument();
		$doc->addScript("https://www.google.com/jsapi");

		$this->assignRef('unsubreasons',$finalReasons);

		if(JRequest::getCmd('export')){
			$exportHelper = acymailing_get('helper.export');
			$exportHelper->exportOneData($finalReasons,'unsub_'.JRequest::getInt('mailid'));
		}

	}

	function forward(){
		$this->unsubscribed();
		$this->setLayout('unsubscribed');
	}

	function unsubscribed(){
		$app = JFactory::getApplication();

		$pageInfo = new stdClass();
		$pageInfo->filter = new stdClass();
		$pageInfo->filter->order = new stdClass();
		$pageInfo->limit = new stdClass();
		$pageInfo->elements = new stdClass();

		$paramBase = ACYMAILING_COMPONENT.'.'.$this->getName().$this->getLayout();
		$pageInfo->filter->order->value = $app->getUserStateFromRequest( $paramBase.".filter_order", 'filter_order',	'a.date','cmd' );
		$pageInfo->filter->order->dir	= $app->getUserStateFromRequest( $paramBase.".filter_order_Dir", 'filter_order_Dir',	'desc',	'word' );
		$pageInfo->search = $app->getUserStateFromRequest( $paramBase.".search", 'search', '', 'string' );
		$pageInfo->search = JString::strtolower( $pageInfo->search );
		$selectedMail = $app->getUserStateFromRequest( $paramBase."filter_mail",'filter_mail',0,'int');

		$pageInfo->limit->value = $app->getUserStateFromRequest( $paramBase.'.list_limit', 'limit', $app->getCfg('list_limit'), 'int' );
		$pageInfo->limit->start = $app->getUserStateFromRequest( $paramBase.'.limitstart', 'limitstart', 0, 'int' );

		$db	= JFactory::getDBO();

		$filters = array();
		$filters[] = "a.action = ".$db->Quote($this->getLayout());

		if(!empty($pageInfo->search)){
			$searchVal = '\'%'.acymailing_getEscaped($pageInfo->search).'%\'';
			$filters[] = implode(" LIKE $searchVal OR ",$this->searchHistory)." LIKE $searchVal";
		}

		if(!empty($selectedMail)){
			$filters[] = 'a.mailid = '.$selectedMail;
		}

		$query = 'SELECT '.implode(' , ',$this->historyFields).' FROM '.acymailing_table('history').' as a';
		$query .= ' JOIN '.acymailing_table('mail').' as b on a.mailid = b.mailid';
		$query .= ' JOIN '.acymailing_table('subscriber').' as c on a.subid = c.subid';
		$query .= ' WHERE ('.implode(') AND (',$filters).')';
		if(!empty($pageInfo->filter->order->value)) $query .= ' ORDER BY '.$pageInfo->filter->order->value.' '.$pageInfo->filter->order->dir;

		if(empty($pageInfo->limit->value)) $pageInfo->limit->value = 100;

		$db->setQuery($query,$pageInfo->limit->start,$pageInfo->limit->value);
		$rows = $db->loadObjectList();

		$queryCount = 'SELECT COUNT(*) FROM #__acymailing_history as a';
		if(!empty($pageInfo->search)){
			$queryCount .= ' JOIN '.acymailing_table('mail').' as b on a.mailid = b.mailid';
			$queryCount .= ' JOIN '.acymailing_table('subscriber').' as c on a.subid = c.subid';
		}
		$queryCount .= ' WHERE ('.implode(') AND (',$filters).')';
		$db->setQuery($queryCount);
		$pageInfo->elements->total = $db->loadResult();

		if(!empty($pageInfo->search)){
			$rows = acymailing_search($pageInfo->search,$rows);
		}

		$pageInfo->elements->page = count($rows);

		jimport('joomla.html.pagination');
		$pagination = new JPagination( $pageInfo->elements->total, $pageInfo->limit->start, $pageInfo->limit->value );

		$query = 'SELECT DISTINCT a.mailid FROM `#__acymailing_history` as a WHERE a.action = '.$db->Quote($this->getLayout()).' AND a.mailid > 0';
		$db->setQuery($query);
		$allMailids = acymailing_loadResultArray($db);

		$emails = array();
		if(!empty($allMailids)){
			$query = 'SELECT subject, mailid FROM `#__acymailing_mail` WHERE mailid IN ('.implode(',',$allMailids).') ORDER BY mailid DESC';
			$db->setQuery($query);
			$emails = $db->loadObjectList();
		}

		$newsletters = array();
		$newsletters[] = JHTML::_('select.option', '0', JText::_('ALL_EMAILS') );
		foreach($emails as $oneMail){
			$newsletters[] = JHTML::_('select.option', $oneMail->mailid, $oneMail->subject );
		}

		$filterMail = JHTML::_('select.genericlist',   $newsletters,'filter_mail', 'class="inputbox" size="1" onchange="document.adminForm.submit( );"', 'value', 'text', (int) $selectedMail );

		$this->assignRef('filterMail',$filterMail);
		$this->assignRef('rows',$rows);
		$this->assignRef('pageInfo',$pageInfo);
		$this->assignRef('pagination',$pagination);
	}


	function detaillisting(){
		$app = JFactory::getApplication();

		$pageInfo = new stdClass();
		$pageInfo->filter = new stdClass();
		$pageInfo->filter->order = new stdClass();
		$pageInfo->limit = new stdClass();
		$pageInfo->elements = new stdClass();
		$config = acymailing_config();

		$paramBase = ACYMAILING_COMPONENT.'.'.$this->getName().$this->getLayout();
		$pageInfo->filter->order->value = $app->getUserStateFromRequest( $paramBase.".filter_order", 'filter_order',	'a.senddate','cmd' );
		$pageInfo->filter->order->dir	= $app->getUserStateFromRequest( $paramBase.".filter_order_Dir", 'filter_order_Dir',	'desc',	'word' );
		$pageInfo->search = $app->getUserStateFromRequest( $paramBase.".search", 'search', '', 'string' );
		$pageInfo->search = JString::strtolower( $pageInfo->search );
		$selectedMail = $app->getUserStateFromRequest( $paramBase."filter_mail",'filter_mail',0,'int');
		$selectedStatus = $app->getUserStateFromRequest( $paramBase."filter_status",'filter_status',0,'string');

		$pageInfo->limit->value = $app->getUserStateFromRequest( $paramBase.'.list_limit', 'limit', $app->getCfg('list_limit'), 'int' );
		$pageInfo->limit->start = $app->getUserStateFromRequest( $paramBase.'.limitstart', 'limitstart', 0, 'int' );

		$database	= JFactory::getDBO();

		$filters = array();
		if(!empty($pageInfo->search)){
			$searchVal = '\'%'.acymailing_getEscaped($pageInfo->search).'%\'';
			$filters[] = implode(" LIKE $searchVal OR ",$this->detailSearchFields)." LIKE $searchVal";
		}

		if(!empty($selectedMail)) $filters[] = 'a.mailid = '.$selectedMail;
		if(!empty($selectedStatus)){
			if($selectedStatus == 'bounce') $filters[] = 'a.bounce > 0';
			elseif($selectedStatus == 'open') $filters[] = 'a.open > 0';
			elseif($selectedStatus == 'notopen') $filters[] = 'a.open < 1';
			elseif($selectedStatus == 'failed') $filters[] = 'a.fail > 0';
		}

		$query = 'SELECT '.implode(' , ',$this->detailSelectFields);
		$query .= ' FROM '.acymailing_table('userstats').' as a';
		$query .= ' JOIN '.acymailing_table('mail').' as b on a.mailid = b.mailid';
		$query .= ' JOIN '.acymailing_table('subscriber').' as c on a.subid = c.subid';
		if(!empty($filters)) $query .= ' WHERE ('.implode(') AND (',$filters).')';
		if(!empty($pageInfo->filter->order->value)) $query .= ' ORDER BY '.$pageInfo->filter->order->value.' '.$pageInfo->filter->order->dir;

		if(empty($pageInfo->limit->value)) $pageInfo->limit->value = 100;

		$database->setQuery($query,$pageInfo->limit->start,$pageInfo->limit->value);
		$rows = $database->loadObjectList();

		if($rows === null){
			acymailing_display(substr(strip_tags($database->getErrorMsg()),0,200).'...','error');
			if(file_exists(ACYMAILING_BACK.'install.acymailing.php')){
				include_once(ACYMAILING_BACK.'install.acymailing.php');
				$installClass = new acymailingInstall();
				$installClass->fromVersion = '3.7.0';
				$installClass->update = true;
				$installClass->updateSQL();
			}
		}

		$queryCount = 'SELECT COUNT(a.subid) FROM #__acymailing_userstats as a';
		if(!empty($pageInfo->search)){
			$queryCount .= ' JOIN '.acymailing_table('mail').' as b on a.mailid = b.mailid';
			$queryCount .= ' JOIN '.acymailing_table('subscriber').' as c on a.subid = c.subid';
		}
		if(!empty($filters)) $queryCount .= ' WHERE ('.implode(') AND (',$filters).')';
		$database->setQuery($queryCount);
		$pageInfo->elements->total = $database->loadResult();

		if(!empty($pageInfo->search)){
			$rows = acymailing_search($pageInfo->search,$rows);
		}

		$pageInfo->elements->page = count($rows);

		jimport('joomla.html.pagination');
		$pagination = new JPagination( $pageInfo->elements->total, $pageInfo->limit->start, $pageInfo->limit->value );

		$toggleClass = acymailing_get('helper.toggle');

		$maildetailstatstype =  acymailing_get('type.detailstatsmail');
		$deliverstatus =  acymailing_get('type.deliverstatus');
		$filtersType = new stdClass();
		if(JRequest::getString('tmpl') == 'component'){
			$filtersType->mail = '<input type="hidden" value="'.$selectedMail.'" name="filter_mail" />';
			$mailClass= acymailing_get('class.mail');
			$this->assign('mailing',$mailClass->get($selectedMail));
		}else{
			$filtersType->mail = $maildetailstatstype->display('filter_mail',$selectedMail);
		}
		$filtersType->status = $deliverstatus->display('filter_status',$selectedStatus);

		if($app->isAdmin()){

			acymailing_setTitle(JText::_('DETAILED_STATISTICS'),'stats','stats&task=detaillisting');

			$bar = JToolBar::getInstance('toolbar');
			$bar->appendButton( 'Link', 'cancel', JText::_('GLOBAL_STATISTICS'), acymailing_completeLink('stats') );

			if(acymailing_isAllowed($config->get('acl_subscriber_export','all'))){
				JToolBarHelper::spacer();
				JToolBarHelper::custom('export', 'acyexport', '',JText::_('ACY_EXPORT'), false);
			}
			JToolBarHelper::divider();
			$bar->appendButton( 'Pophelp','stats-detaillisting');
			if(acymailing_isAllowed($config->get('acl_cpanel_manage','all'))) $bar->appendButton( 'Link', 'acymailing', JText::_('ACY_CPANEL'), acymailing_completeLink('dashboard') );
		}

		$this->assignRef('filters',$filtersType);
		$this->assignRef('toggleClass',$toggleClass);
		$this->assignRef('rows',$rows);
		$this->assignRef('pageInfo',$pageInfo);
		$this->assignRef('pagination',$pagination);

	}

	function listing(){
		$app = JFactory::getApplication();
		$pageInfo = new stdClass();
		$pageInfo->filter = new stdClass();
		$pageInfo->filter->order = new stdClass();
		$pageInfo->limit = new stdClass();
		$pageInfo->elements = new stdClass();
		$config = acymailing_config();

		JHTML::_('behavior.modal','a.modal');

		$paramBase = ACYMAILING_COMPONENT.'.'.$this->getName().$this->getLayout();
		$pageInfo->filter->order->value = $app->getUserStateFromRequest( $paramBase.".filter_order", 'filter_order',	'a.senddate','cmd' );
		$pageInfo->filter->order->dir	= $app->getUserStateFromRequest( $paramBase.".filter_order_Dir", 'filter_order_Dir',	'desc',	'word' );
		$pageInfo->search = $app->getUserStateFromRequest( $paramBase.".search", 'search', '', 'string' );
		$pageInfo->search = JString::strtolower( $pageInfo->search );

		$pageInfo->limit->value = $app->getUserStateFromRequest( $paramBase.'.list_limit', 'limit', $app->getCfg('list_limit'), 'int' );
		$pageInfo->limit->start = $app->getUserStateFromRequest( $paramBase.'.limitstart', 'limitstart', 0, 'int' );

		$database	= JFactory::getDBO();

		$filters = array();
		if(!empty($pageInfo->search)){
			$searchVal = '\'%'.acymailing_getEscaped($pageInfo->search,true).'%\'';
			$filters[] = implode(" LIKE $searchVal OR ",$this->searchFields)." LIKE $searchVal";
		}

		$query = 'SELECT '.implode(' , ',$this->selectFields);
		$query .= ' FROM '.acymailing_table('stats').' as a';
		$query .= ' JOIN '.acymailing_table('mail').' as b on a.mailid = b.mailid';
		if(!empty($filters)) $query .= ' WHERE ('.implode(') AND (',$filters).')';
		if(!empty($pageInfo->filter->order->value)){
			$query .= ' ORDER BY '.$pageInfo->filter->order->value.' '.$pageInfo->filter->order->dir;
		}

		$database->setQuery($query,$pageInfo->limit->start,$pageInfo->limit->value);
		$rows = $database->loadObjectList();

		if($rows === null){
			acymailing_display(substr(strip_tags($database->getErrorMsg()),0,200).'...','error');
			if(file_exists(ACYMAILING_BACK.'install.acymailing.php')){
				include_once(ACYMAILING_BACK.'install.acymailing.php');
				$installClass = new acymailingInstall();
				$installClass->fromVersion = '3.6.0';
				$installClass->update = true;
				$installClass->updateSQL();
			}
		}

		$queryCount = 'SELECT COUNT(a.mailid) FROM '.acymailing_table('stats').' as a';
		if(!empty($pageInfo->search)){
			$queryCount .= ' JOIN '.acymailing_table('mail').' as b on a.mailid = b.mailid';
 		}
 		if(!empty($filters)) $queryCount .= ' WHERE ('.implode(') AND (',$filters).')';

		$database->setQuery($queryCount);
		$pageInfo->elements->total = $database->loadResult();

		if(!empty($pageInfo->search)){
			$rows = acymailing_search($pageInfo->search,$rows);
		}

		$pageInfo->elements->page = count($rows);

		jimport('joomla.html.pagination');
		$pagination = new JPagination( $pageInfo->elements->total, $pageInfo->limit->start, $pageInfo->limit->value );

		acymailing_setTitle(JText::_('GLOBAL_STATISTICS'),'stats','stats');

		$bar = JToolBar::getInstance('toolbar');
		JToolBarHelper::custom('exportglobal', 'acyexport', '',JText::_('ACY_EXPORT'), false);
		JToolBarHelper::spacer();
		if(acymailing_isAllowed($config->get('acl_statistics_delete','all'))) JToolBarHelper::deleteList(JText::_('ACY_VALIDDELETEITEMS'));
		JToolBarHelper::divider();
		$bar->appendButton( 'Pophelp','stats-listing');
		if(acymailing_isAllowed($config->get('acl_cpanel_manage','all'))) $bar->appendButton( 'Link', 'acymailing', JText::_('ACY_CPANEL'), acymailing_completeLink('dashboard') );

		$this->assignRef('rows',$rows);
		$this->assignRef('pageInfo',$pageInfo);
		$this->assignRef('pagination',$pagination);

	}

	function mailinglist($export = 0){
		$mailid = JRequest::getInt('mailid');
		if(empty($mailid)) return;

		$doc = JFactory::getDocument();
		$doc->addStyleSheet( ACYMAILING_CSS.'acyprint.css?v='.filemtime(ACYMAILING_MEDIA.'css'.DS.'acyprint.css'),'text/css','print' );

		$mailClass = acymailing_get('class.mail');
		$mailing = $mailClass->get($mailid);

		$mydata = array();
		$isData = true;

		$db = JFactory::getDBO();
		$query = 'SELECT lm.listid, l.name, l.color FROM #__acymailing_list l';
		$query .= ' JOIN #__acymailing_listmail lm ON l.listid=lm.listid';
		$query .= ' WHERE lm.mailid=' . intval($mailid) . ' ORDER BY l.ordering';
		$db->setQuery($query);
		$sqlRes = $db->loadObjectList();

		if(empty($sqlRes)){
			$query = 'SELECT listid, name, color FROM #__acymailing_list';
			$query .= ' WHERE welmailid=' . intval($mailid) . ' OR unsubmailid=' . intval($mailid) . ' GROUP BY listid';
			$db->setQuery($query);
			$sqlRes = $db->loadObjectList();
			if(empty($sqlRes)){
				acymailing_display("This newsletter is not assigned to any list",'warning');
				$isData = false;
				return;
			}
		}

		$arrayColors = array();
		$arrayList = array();
		foreach($sqlRes as $list){
			$mydata[$list->listid] = array();
			$mydata[$list->listid]['listid'] = $list->listid;
			$mydata[$list->listid]['listname'] = $list->name;
			$mydata[$list->listid]['nbMailSent'] = 0;
			$mydata[$list->listid]['nbHtml'] = 0;
			$mydata[$list->listid]['nbOpen'] = 0;
			$mydata[$list->listid]['nbOpenRatio'] = 0;
			$mydata[$list->listid]['nbClic'] = 0;
			$mydata[$list->listid]['nbClicRatio'] = 0;
			$mydata[$list->listid]['nbForward'] = 0;
			$mydata[$list->listid]['nbBounce'] = 0;
			$mydata[$list->listid]['nbBounceRatio'] = 0;
			$mydata[$list->listid]['nbUnsub'] = 0;
			$mydata[$list->listid]['nbUnsubRatio'] = 0;

			$mydata[$list->listid]['color'] = $list->color;
			array_push($arrayColors, $list->color);
			array_push($arrayList, $list->listid);
		}
		$listColors = "'" . implode("', '", $arrayColors) . "'";
		$listListes = implode(',', $arrayList);

		$query = 'SELECT ls.listid, COUNT(*) as nbSent, SUM(IF(html=1, 1, 0)) as nbHtml, SUM(IF(open<>0, 1, 0)) as nbOpen, SUM(IF(bounce<>0, 1, 0)) as nbBounce ';
		$query .= ' FROM #__acymailing_userstats us JOIN #__acymailing_listsub ls ON us.subid = ls.subid';
		$query .= ' WHERE ls.listid IN (' . $listListes . ') AND us.mailid=' . intval($mailid) . ' GROUP BY ls.listid';
		$db->setQuery($query);
		$sqlRes = $db->loadObjectList();
		$totalSent = 0;
		if(!empty($sqlRes)){
			foreach($sqlRes as $lineRes){
				$mydata[$lineRes->listid]['nbMailSent'] = $lineRes->nbSent;
				$mydata[$lineRes->listid]['nbHtml'] = $lineRes->nbHtml;
				$mydata[$lineRes->listid]['nbOpen'] = $lineRes->nbOpen;
				$mydata[$lineRes->listid]['nbOpenRatio'] = number_format($lineRes->nbOpen / $mydata[$lineRes->listid]['nbHtml'] * 100, 1);
				$mydata[$lineRes->listid]['nbBounce'] = $lineRes->nbBounce;
				$mydata[$lineRes->listid]['nbBounceRatio'] = number_format($lineRes->nbBounce / $mydata[$lineRes->listid]['nbMailSent'] * 100, 1);
				$totalSent += $lineRes->nbSent;
			}
		} else{
			acymailing_display("No statistics recorded",'warning');
			$isData = false;
			return;
		}

		$query = 'SELECT ls.listid, COUNT(DISTINCT(uc.subid)) AS nbClic FROM #__acymailing_urlclick as uc JOIN #__acymailing_listsub as ls ON uc.subid=ls.subid';
		$query .= ' WHERE ls.listid IN (' . $listListes . ') AND uc.mailid=' . intval($mailid) . ' GROUP BY ls.listid';
		$db->setQuery($query);
		$sqlRes = $db->loadObjectList();
		if(!empty($sqlRes)){
			foreach($sqlRes as $lineRes){
				$mydata[$lineRes->listid]['nbClic'] = $lineRes->nbClic;
				$mydata[$lineRes->listid]['nbClicRatio'] = number_format($lineRes->nbClic / $mydata[$lineRes->listid]['nbHtml'] * 100, 1);
			}
		}

		$query = 'SELECT ls.listid, SUM(IF(h.action=\'forward\', 1, 0)) as nbForward, SUM(IF(h.action=\'unsubscribed\', 1, 0)) as nbUnsub';
		$query .= ' FROM #__acymailing_history as h JOIN #__acymailing_listsub ls ON h.subid=ls.subid';
		$query .= ' WHERE ls.listid IN (' . $listListes . ') AND h.mailid=' . intval($mailid) . ' GROUP BY ls.listid';
		$db->setQuery($query);
		$sqlRes = $db->loadObjectList();
		if(!empty($sqlRes)){
			foreach($sqlRes as $lineRes){
				$mydata[$lineRes->listid]['nbForward'] = $lineRes->nbForward;
				$mydata[$lineRes->listid]['nbUnsub'] = $lineRes->nbUnsub;
				$mydata[$lineRes->listid]['nbUnsubRatio'] = number_format($lineRes->nbUnsub / $mydata[$lineRes->listid]['nbMailSent'] * 100, 1);
			}
		}

		$this->assignRef('mydata', $mydata);
		$this->assignRef('mailing', $mailing);
		$this->assignRef('listColors', $listColors);
		$this->assignRef('isData', $isData);
		$this->assignRef('totalSent', $totalSent);

		if(JRequest::getCmd('export')){
			$exportHelper = acymailing_get('helper.export');
			$config = acymailing_config();
			$encodingClass = acymailing_get('helper.encoding');

			$exportHelper->addHeaders('mailingList_'.JRequest::getInt('mailid'));

			$eol= "\r\n";
			$before = '"';
			$separator = '"'.str_replace(array('semicolon','comma'),array(';',','), $config->get('export_separator',';')).'"';
			$exportFormat = $config->get('export_format','UTF-8');
			$after = '"';

			$titles = array(JText::_('LIST'),JText::_('LIST_NAME'),JText::_('ACY_SENT_EMAILS'),JText::_('SENT_HTML'),JText::_('OPEN'),JText::_('OPEN').' (%)',JText::_('CLICKED_LINK'),JText::_('CLICKED_LINK').' (%)',JText::_('FORWARDED'),JText::_('BOUNCES'),JText::_('BOUNCES').' (%)',JText::_('UNSUBSCRIBED'),JText::_('UNSUBSCRIBED').' (%)',JText::_('COLOUR'));
			$titleLine = $before.implode($separator, $titles).$after.$eol;
			echo $titleLine;

			foreach($mydata as $listid => $listDetails){
				$line = '';
				foreach($listDetails as $name => $value){
					$line .= $value.$separator;
				}
				$line = substr($line, 0, strlen($line)-strlen($separator));
				$line = $before.$encodingClass->change($line, 'UTF-8', $exportFormat).$after.$eol;
				echo $line;
			}
			exit;
		}
	}
}
